// // // // // // // // // // // // // // // //
//
//	Enemy Territory - ObjectBitmap.h
//
//	erstellt 13.1.98 von Andreas Warnke
//	geändert 14.1.98 von Andreas Warnke
//



// // // // // // // // // // // // // // // //
//
//	include:
//

#include "ObjectBitmap.h"
#include "DisplayedObject.h"
#include "Ebene.h"
#include "AsciiKette.h"
#include "FateMaker.h"



// // // // // // // // // // // // // // // //
//
//	static:
//

BList ObjectBitmap :: ObjektListe;
BList ObjectBitmap :: WabenListe;
sem_id ObjectBitmap :: DieSemaphore = 0;
FateMaker ObjectBitmap :: Fate;



// // // // // // // // // // // // // // // //
//
//	Konstruktor:
//

void ObjectBitmap :: Konstruktor ()
{
	DieSemaphore = create_sem ( 1, "CreateBitmapSem");
};



// // // // // // // // // // // // // // // //
//
//	Destruktor:
//

void ObjectBitmap :: Destruktor ()
{
	delete_sem ( DieSemaphore );
};



// // // // // // // // // // // // // // // //
//
//	DeleteMaps:
//

bool DeleteBitmap ( BBitmap * inMap );
bool DeleteBitmap ( BBitmap * inMap )
{
	if ( inMap != NULL )
		delete inMap;
	return false;
};

bool DeleteBitmapList ( BList * inSpieler );
bool DeleteBitmapList ( BList * inSpieler )
{
	if ( inSpieler != NULL )
	{
		inSpieler -> DoForEach ( (bool (*) (void*)) DeleteBitmap);
		delete inSpieler;
	};
	return false;
};

bool DeleteBitmapListList ( BList * inTyp );
bool DeleteBitmapListList ( BList * inTyp )
{
	if ( inTyp != NULL )
	{
		inTyp -> DoForEach ( (bool (*) (void*)) DeleteBitmapList);
		delete inTyp;
	};
	return false;
};

void ObjectBitmap :: DeleteMaps ()
{
	acquire_sem ( DieSemaphore );
	ObjektListe . DoForEach ( (bool (*) (void*) ) DeleteBitmapListList );
	ObjektListe . MakeEmpty ();
	WabenListe . DoForEach ( (bool (*) (void*) ) DeleteBitmap );
	WabenListe . MakeEmpty ();
	release_sem ( DieSemaphore );
};



// // // // // // // // // // // // // // // //
//
//	GetBitmap:
//

BBitmap * ObjectBitmap :: GetBitmap (
	unsigned int inTyp,
	unsigned int inOwner,
	unsigned int inZahl)
{
	//	korrekte Parameter?
	if (inZahl == 0)
		return NULL; 

	if ( CreateListItem ( ObjektListe, inTyp) )
	{
		((BList**) ObjektListe . Items ()) [inTyp] = new BList(10);
		release_sem ( DieSemaphore );
	};
	
	BList * SpielerListe = (BList*)(ObjektListe . ItemAt ( inTyp ));
	if ( SpielerListe != NULL )
	{
		if ( CreateListItem ( *SpielerListe, inOwner ) )
		{
			((BList**) SpielerListe -> Items ()) [inOwner] = new BList(5);
			release_sem ( DieSemaphore );
		};
			
		BList * ZahlListe = (BList*)(SpielerListe -> ItemAt ( inOwner ));
		if ( ZahlListe != NULL)
		{
			unsigned int pos = inZahl - 1;
			if ( CreateListItem ( *ZahlListe, pos) )
			{
				((BBitmap**) ZahlListe -> Items ()) [pos]
					= ObjektCreate ( inTyp, inOwner, inZahl);
				release_sem ( DieSemaphore );
			};
			
			return (BBitmap*)ZahlListe -> ItemAt ( pos);
		}
		else
			return NULL;
	}
	else
		return NULL;
};



// // // // // // // // // // // // // // // //
//
//	CreateListItem:
//

bool ObjectBitmap :: CreateListItem ( BList & inListe, int inIndex )
{
	if ( inListe . CountItems () <= inIndex )
	{
		//	Die Liste ist zu kurz.
		acquire_sem ( DieSemaphore );
		
		//	Mache Liste lang genug:
		unsigned int FirstFree = inListe . CountItems ();
		while ( FirstFree <= inIndex )
		{
			inListe . AddItem ( NULL, FirstFree);
			FirstFree ++;
		};
		
		if ( inListe . CountItems () > inIndex )
		if ( inListe . ItemAt( inIndex ) == NULL )
			//	Die Liste ist lang genug.
			return true;
		
		//	Die Liste ist immernoch zu kurz.
		release_sem ( DieSemaphore );
		return false;
	};
		
	if ( inListe . ItemAt (inIndex) != NULL )
		//	Item existiert schon.
		return false;
		
	//	Item existiert noch nicht.
	acquire_sem ( DieSemaphore );
	
	if ( inListe . ItemAt (inIndex) != NULL )
	{
		//	Item existiert schon.
		release_sem ( DieSemaphore );
		return false;
	};
	
	return true;
};



// // // // // // // // // // // // // // // //
//
//	GetWabe:
//

BBitmap * ObjectBitmap :: GetWabe (
	unsigned int inTyp )
{
	if ( CreateListItem ( WabenListe, inTyp ) )
	{
		((BBitmap**)WabenListe . Items()) [ int(inTyp) ] = WabeCreate ( inTyp );
		release_sem ( DieSemaphore );
	};
		
	return (BBitmap*) WabenListe . ItemAt( inTyp );
};



// // // // // // // // // // // // //
//
//	WabeDraw:
//

inline rgb_color Color (int, int, int, int );
rgb_color Color (int r, int g, int b, int a) { rgb_color dummy = {r,g,b,a}; return dummy;};

void ObjectBitmap :: WabeDraw ( BView * inMaler, int inNr )
{
	//	Löschen des Hintergrunds:
	BRect Rand = inMaler -> Bounds ();
	inMaler -> SetDrawingMode ( B_OP_COPY );
	if ( inNr != FT_HighlightWabe )
		inMaler -> SetHighColor ( B_TRANSPARENT_32_BIT );
	else
		inMaler -> SetHighColor ( 0x00, 0x00, 0x00 );
	inMaler -> FillRect ( Rand );
	
	//	Berechnen des 6-Eck Polygons:	
	BPoint Ecke [6] ;
	const float Halbradius ( _Ebene_h_Waben_Hoehe / 4 );
	Ecke [0] = BPoint ( ( _Ebene_h_Waben_Breite - 1 ) / 2, 0 );
	Ecke [1] = BPoint ( _Ebene_h_Waben_Breite - 1, Halbradius - 1 );
	Ecke [2] = BPoint ( _Ebene_h_Waben_Breite - 1, _Ebene_h_Waben_Hoehe - Halbradius - 1);
	Ecke [3] = BPoint ( ( _Ebene_h_Waben_Breite - 1 ) / 2, _Ebene_h_Waben_Hoehe - 1 );
	Ecke [4] = BPoint ( 0, _Ebene_h_Waben_Hoehe - Halbradius - 1 );
	Ecke [5] = BPoint ( 0, Halbradius - 1 );
	
	//	Bestimmen der Hintergrundfarbe:
	rgb_color DieFarbe;
	int sRealType = ( inNr & FT_TypeMask );
	if ( ( FT_Plain <= sRealType ) && ( sRealType < FT_Plain + FI_Plain ) )
		DieFarbe = Color( 0xee, 0xdd, 0xaa, 0x00 );
	else if ( ( FT_Forrest <= sRealType ) && ( sRealType < FT_Forrest + FI_Forrest ) )
		DieFarbe = Color( 0x33, 0xbb, 0x55, 0x00 );
	else if ( ( FT_Undiscovered <= sRealType ) && ( sRealType < FT_Undiscovered + FI_Undiscovered ) )
		DieFarbe = Color( 0x00, 0x88, 0xaa, 0x00 );
	else if ( ( FT_Sea <= sRealType ) && ( sRealType < FT_Sea + FI_Sea ) )
		DieFarbe = Color( 0x00, 0x66, 0xee, 0x00 );
	else if ( ( FT_Mountain <= sRealType ) && ( sRealType < FT_Mountain + FI_Mountain ) )
		DieFarbe = Color( 0xff, 0x00, 0x00, 0x00 );
	else if ( FT_HighlightWabe == sRealType ) 
 		DieFarbe = Color( 0x7f, 0x7f, 0x7f, 0x00 );
	else	//	FT_EndOfWorld
		DieFarbe = Color( 0xff, 0xee, 0xdd, 0x00 );
		
	//	Setze Farbe:
	inMaler -> SetHighColor ( DieFarbe );
	
	//	Malen des 6-Ecks:
	inMaler -> FillPolygon ( Ecke, 6 );
	
	//	Schatten malen:
	if ( ( inNr & FT_ShadowMask ) != 0 )
		for ( int x = 0; x < _Ebene_h_Waben_Breite; x++ )
			for ( int y = 0; y < _Ebene_h_Waben_Hoehe; y++ )
				if ( Fate . GetLong ( 2 ) == 0 )
				{
					int dummyX;
					int dummyY;
					Ebene :: GetMapLocation (
						x + _Ebene_h_Karten_Rand,
						y + _Ebene_h_Waben_dy + _Ebene_h_Karten_Rand,
						dummyX,
						dummyY);
					inMaler -> SetHighColor (
						Color( Fate . GetLong ( 0x100 ),
						Fate . GetLong ( 0x100 ),
						Fate . GetLong ( 0x100 ),
						0x00 ) );
					if ( ( dummyX == 0 ) && ( dummyY == 1 ) )
						inMaler -> FillRect ( BRect ( x, y, x, y ) );
				};
	
};

rgb_color ChangeLight ( rgb_color inColor, int inUpRange, int inDownRange );
/*
rgb_color ChangeLight ( rgb_color inColor, int inUpRange, int inDownRange )
{
	int inRange = inUpRange + inDownRange;
	int red = inColor . red + ObjectBitmap :: Fate . GetLong ( inRange ) - inDownRange;
	if ( red < 0 ) red = 0;
	if ( red >= 0x100 ) red = 0xff;
	inColor . red = red;
	int green = inColor . green + ObjectBitmap :: Fate . GetLong ( inRange ) - inDownRange;
	if ( green < 0 ) green = 0;
	if ( green >= 0x100 ) green = 0xff;
	inColor . green = green;
	int blue = inColor . blue + ObjectBitmap :: Fate . GetLong ( inRange ) - inDownRange;
	if ( blue < 0 ) blue = 0;
	if ( blue >= 0x100 ) blue = 0xff;
	inColor . blue = blue;
	return inColor;
};
*/
/*
rgb_color ChangeLight ( rgb_color inColor, int inUpRange, int inDownRange )
{
	int inRange = inUpRange + inDownRange;
	int sDelta = ObjectBitmap :: Fate . GetLong ( inRange ) - inDownRange;
	int red = inColor . red + sDelta;
	if ( red < 0 ) red = 0;
	if ( red >= 0x100 ) red = 0xff;
	inColor . red = red;
	int green = inColor . green + sDelta;
	if ( green < 0 ) green = 0;
	if ( green >= 0x100 ) green = 0xff;
	inColor . green = green;
	int blue = inColor . blue + sDelta;
	if ( blue < 0 ) blue = 0;
	if ( blue >= 0x100 ) blue = 0xff;
	inColor . blue = blue;
	return inColor;
};
*/

rgb_color ChangeLight ( rgb_color inColor, int inUpRange, int inDownRange )
{
	int inRange = inUpRange + inDownRange;
	int sDeltaG = ObjectBitmap :: Fate . GetLong ( inRange / 2 ) - ( inDownRange / 2 );
	int sDeltaS = ObjectBitmap :: Fate . GetLong ( inRange / 2 ) - ( inDownRange / 2 );
	int red = inColor . red + sDeltaG + sDeltaS;
	if ( red < 0 ) red = 0;
	if ( red >= 0x100 ) red = 0xff;
	inColor . red = red;
	sDeltaS = ObjectBitmap :: Fate . GetLong ( inRange / 2 ) - ( inDownRange / 2 );
	int green = inColor . green + sDeltaG + sDeltaS;
	if ( green < 0 ) green = 0;
	if ( green >= 0x100 ) green = 0xff;
	inColor . green = green;
	sDeltaS = ObjectBitmap :: Fate . GetLong ( inRange / 2 ) - ( inDownRange / 2 );
	int blue = inColor . blue + sDeltaG + sDeltaS ;
	if ( blue < 0 ) blue = 0;
	if ( blue >= 0x100 ) blue = 0xff;
	inColor . blue = blue;
	return inColor;
};

inline float fsqr ( float inA );
float fsqr ( float inA ) { return inA * inA; };

void ObjectBitmap :: WabeDraw2 ( BView * inMaler, int inNr )
{
	//	Löschen des Hintergrunds:
	BRect Rand = inMaler -> Bounds ();
	inMaler -> SetDrawingMode ( B_OP_COPY );
	if ( inNr != FT_HighlightWabe )
		inMaler -> SetHighColor ( B_TRANSPARENT_32_BIT );
	else
		inMaler -> SetHighColor ( 0x00, 0x00, 0x00 );
	inMaler -> FillRect ( Rand );
	
	//	Bestimmen der Hintergrundfarbe:
	rgb_color DieFarbe;
	int sRealType = ( inNr & FT_TypeMask );
	if ( ( FT_Plain <= sRealType ) && ( sRealType < FT_Plain + FI_Plain ) )
		DieFarbe = Color( 0xee, 0xdd, 0xaa, 0x00 );
	else if ( ( FT_Forrest <= sRealType ) && ( sRealType < FT_Forrest + FI_Forrest ) )
		DieFarbe = Color( 0x33, 0xbb, 0x55, 0x00 );
	else if ( ( FT_Undiscovered <= sRealType ) && ( sRealType < FT_Undiscovered + FI_Undiscovered ) )
		DieFarbe = Color( 0xbb, 0x00, 0x00, 0x00 );
	else if ( ( FT_Mountain <= sRealType ) && ( sRealType < FT_Mountain + FI_Mountain ) )
	{
		int sVari = sRealType - FT_Mountain;
		DieFarbe = Color( 0x77 + 0x11 * sVari, 0x88 + 0x08 * sVari, 0x88 + 0x08 * sVari, 0x00 );
	}
	else if ( ( FT_Sea <= sRealType ) && ( sRealType < FT_Sea + FI_Sea ) )
		DieFarbe = Color( 0x00, 0x66, 0xee, 0x00 );
	else if ( FT_HighlightWabe == sRealType ) 
 		DieFarbe = Color( 0x7f, 0x7f, 0x7f, 0x00 );
	else	//	FT_EndOfWorld
		DieFarbe = Color( 0xff, 0xee, 0xd7, 0x00 );
		
	//	Malen der Pixel:
	for ( int x = 0; x < _Ebene_h_Waben_Breite; x++ )
		for ( int y = 0; y < _Ebene_h_Waben_Hoehe; y++ )
		{
			//	Ist der Punkt in der Wabe?
			int dummyX;
			int dummyY;
			int dummyX2;
			int dummyY2;
			Ebene :: GetMapLocation (
				x + _Ebene_h_Karten_Rand,
				y + _Ebene_h_Waben_dy + _Ebene_h_Karten_Rand,
				dummyX,
				dummyY);
			Ebene :: GetMapLocation (
				x + _Ebene_h_Karten_Rand + 0.5,
				y + _Ebene_h_Waben_dy + _Ebene_h_Karten_Rand + 0.5,
				dummyX2,
				dummyY2);
			if ( ( ( dummyX == 0 ) && ( dummyY == 1 ) ) || ( ( dummyX2 == 0 ) && ( dummyY2 == 1 ) ) )
			{
				//	Dies ist ein zu malender punkt.
				//	verändere die Farbe leicht:
				rgb_color PunktFarbe;
				if ( ( ( inNr & FT_ShadowMask ) == 0 )
					&& ( ( FT_Undiscovered + FI_Undiscovered <= sRealType ) || ( sRealType < FT_Undiscovered ) ) )
					//	Dieses Feld ist sichtbar.
					PunktFarbe = ChangeLight ( DieFarbe, 32, 32 );
				else
					PunktFarbe = ChangeLight ( DieFarbe, 32, 192 );
				//	Sonderbehandlung für Highlight-Wabe:
				if ( sRealType == FT_HighlightWabe )
				{
					int sHLval = 0x77 * ( (
						fsqr( x - ( _Ebene_h_Waben_Breite - 1.0 ) / 2.0 )
						+ fsqr ( y - ( _Ebene_h_Waben_Hoehe - 1.0 ) / 2.0 ) )
						/ ( fsqr ( ( _Ebene_h_Waben_Hoehe - 1.0 ) / 2.0 ) ) );
					//	Positiv:
					//	PunktFarbe = Color ( 0x77 - sHLval, 0x77 - sHLval, 0x77 - sHLval, 0x00 );						
					//	Negativ:
					PunktFarbe = Color ( sHLval, sHLval, sHLval, 0x00 );						
				};
				
				//	Setze Farbe:
				inMaler -> SetHighColor ( PunktFarbe );		
	
				//	Male den Punkt:
				inMaler -> FillRect ( BRect ( x, y, x, y ) );				
			};	
		};
};



// // // // // // // // // // // // //
//
//	WabeCreate:
//

BBitmap * ObjectBitmap :: WabeCreate ( int inNr )
{
	//	Bitmap zum Malen 
	BBitmap *Leinwand;
	BBitmap *Mosaik = NULL;
	
	//	Erstellen der Leinwand-Bitmap:
	Leinwand = new BBitmap (
		BRect ( 0, 0, _Ebene_h_Waben_Breite - 1, _Ebene_h_Waben_Hoehe - 1 ),
		//	B_RGB_32_BIT,
		B_COLOR_8_BIT,
		true );
	
	//	Gibt es eine Leinwand?
	if ( Leinwand != NULL )
	{
		//	View zum Malen erstellen:
		BView *Maler = new BView (
			Leinwand -> Bounds (),
			"Maler",
			B_FOLLOW_NONE,
			0);
			
		//	Malen?
		if ( Maler != NULL )
		{
			//	Window locken:
			Leinwand -> Lock();
			
			//	Maler in Leinwand einfügen:
			Leinwand -> AddChild ( Maler );
			
			//	Malen!
			WabeDraw2 ( Maler, inNr );
			
			//	Maler puffer leeren:
			Maler -> Sync();
			
			//	Maler aus Leinwand entfernen:
			Leinwand -> RemoveChild ( Maler );
			
			//	Window unlocken:
			Leinwand -> Unlock();
			
			//	Maler löschen.
			delete Maler;
		};
		
		//	Erstellen der fertigen Bitmap:
		Mosaik = new BBitmap (
			BRect ( 0, 0, _Ebene_h_Waben_Breite - 1, _Ebene_h_Waben_Hoehe - 1 ),
			//	B_RGB_32_BIT,
			B_COLOR_8_BIT,
			false );
			
		//	Kopie des Bildes in das Mosaik:
		if ( Mosaik != NULL )
			memcpy ( Mosaik -> Bits(), Leinwand -> Bits(), Mosaik -> BitsLength());
			
		//	delete Leinwand:
		delete Leinwand;
	}
	
	//	Fertig:
	return Mosaik;
};



// // // // // // // // // // // // //
//
//	ObjektCreate:
//

BBitmap * ObjectBitmap :: ObjektCreate (
	unsigned int inTyp,
	unsigned int inOwner,
	unsigned int inZahl)
{
	//	Bitmap zum Malen 
	BBitmap *Leinwand;
	BBitmap *Mosaik = NULL;
	
	//	Erstellen der Leinwand-Bitmap:
	Leinwand = new BBitmap (
		BRect ( 0, 0, _Ebene_h_Objekt_Breite - 1, _Ebene_h_Objekt_Hoehe - 1 ),
		//	B_RGB_32_BIT,
		B_COLOR_8_BIT,
		true );
	
	//	Gibt es eine Leinwand?
	if ( Leinwand != NULL )
	{
		//	View zum Malen erstellen:
		BView *Maler = new BView (
			Leinwand -> Bounds (),
			"Maler",
			B_FOLLOW_NONE,
			0);
			
		//	Malen?
		if ( Maler != NULL )
		{
			//	Window locken:
			Leinwand -> Lock();
			
			//	Maler in Leinwand einfügen:
			Leinwand -> AddChild ( Maler );
			
			//	Malen!
			ObjektDraw ( Maler, inTyp, inOwner, inZahl);
			
			//	Maler puffer leeren:
			Maler -> Sync();
			
			//	Maler aus Leinwand entfernen:
			Leinwand -> RemoveChild ( Maler );
			
			//	Window unlocken:
			Leinwand -> Unlock();
			
			//	Maler löschen.
			delete Maler;
		};

		//	Erstellen der Bitmap ohne Window:
		Mosaik = new BBitmap (
			BRect ( 0, 0, _Ebene_h_Objekt_Breite - 1, _Ebene_h_Objekt_Hoehe - 1 ),
			//	B_RGB_32_BIT,
			B_COLOR_8_BIT,
			false );
			
		//	Existiert Mosaik?
		if ( Mosaik != NULL )
			memcpy ( Mosaik -> Bits(), Leinwand -> Bits(), Mosaik -> BitsLength());

		//	Lösche Leinwand:
		delete Leinwand;
	};
	
	//	Fertig:
	return Mosaik;
};



// // // // // // // // // // // // //
//
//	ObjektDraw:
//

enum { StopPolyCount = 19 };
const BPoint StopPoly [ StopPolyCount ] =
{
	BPoint ( 0.50, 0.00 ),
	BPoint ( 0.65, 0.15 ),
	BPoint ( 0.55, 0.30 ),
	BPoint ( 0.80, 0.35 ),
	BPoint ( 0.80, 0.75 ),
	BPoint ( 0.70, 0.65 ),
	BPoint ( 0.70, 0.95 ),
	BPoint ( 0.80, 1.00 ),
	BPoint ( 0.55, 1.00 ),
	BPoint ( 0.55, 0.70 ),
	BPoint ( 0.45, 0.70 ),
	BPoint ( 0.45, 1.00 ),
	BPoint ( 0.20, 1.00 ),
	BPoint ( 0.30, 0.95 ),
	BPoint ( 0.30, 0.65 ),
	BPoint ( 0.20, 0.75 ),
	BPoint ( 0.20, 0.35 ),
	BPoint ( 0.45, 0.30 ),
	BPoint ( 0.35, 0.15 )
};

enum { RunPolyCount = 19 };
const BPoint RunPoly [ RunPolyCount ] =
{
	BPoint ( 0.50, 0.00 ),
	BPoint ( 0.65, 0.15 ),
	BPoint ( 0.55, 0.30 ),
	BPoint ( 0.90, 0.45 ),
	BPoint ( 0.90, 0.60 ),
	BPoint ( 0.65, 0.50 ),
	BPoint ( 0.65, 0.65 ),
	BPoint ( 0.90, 1.00 ),
	BPoint ( 0.70, 1.00 ),
	BPoint ( 0.55, 0.70 ),
	BPoint ( 0.45, 0.70 ),
	BPoint ( 0.30, 1.00 ),
	BPoint ( 0.10, 1.00 ),
	BPoint ( 0.35, 0.65 ),
	BPoint ( 0.35, 0.50 ),
	BPoint ( 0.10, 0.60 ),
	BPoint ( 0.10, 0.45 ),
	BPoint ( 0.45, 0.30 ),
	BPoint ( 0.35, 0.15 )
};

enum { VillagePolyCount = 25 };
const BPoint VillagePoly [ VillagePolyCount ] =
{
	BPoint ( 0.00, 0.30 ),
	BPoint ( 0.15, 0.30 ),
	BPoint ( 0.15, 0.00 ),
	BPoint ( 0.30, 0.00 ),
	BPoint ( 0.30, 0.10 ),
	BPoint ( 0.15, 0.10 ),
	BPoint ( 0.15, 0.30 ),
	BPoint ( 0.30, 0.30 ),
	BPoint ( 0.30, 0.60 ),
	BPoint ( 0.70, 0.60 ),
	BPoint ( 0.70, 0.30 ),
	BPoint ( 0.85, 0.30 ),
	BPoint ( 0.85, 0.00 ),
	BPoint ( 1.00, 0.00 ),
	BPoint ( 1.00, 0.10 ),
	BPoint ( 0.85, 0.10 ),
	BPoint ( 0.85, 0.30 ),
	BPoint ( 1.00, 0.30 ),
	BPoint ( 1.00, 1.00 ),
	BPoint ( 0.65, 1.00 ),
	BPoint ( 0.65, 0.80 ),
	BPoint ( 0.50, 0.70 ),
	BPoint ( 0.35, 0.80 ),
	BPoint ( 0.35, 1.00 ),
	BPoint ( 0.00, 1.00 )
};

void StrokeScaledPoly ( BView * inMaler, const BPoint * inPoly, int inPolyCount );
void StrokeScaledPoly ( BView * inMaler, const BPoint * inPoly, int inPolyCount )
{
	BPoint * sScaled = new BPoint [inPolyCount];
	if ( sScaled != NULL )
	{
		//	neues Feld angelegt.
		//	Skaliere das Polygon:
		BRect sFeld = inMaler -> Bounds ();
		for ( int i = 0; i < inPolyCount; i++ )
		{
			sScaled [i] . x = inPoly [i] . x * sFeld . right;
			sScaled [i] . y = inPoly [i] . y * sFeld . bottom;
		};
		//	Malen:
		inMaler -> FillPolygon ( sScaled, inPolyCount, B_SOLID_LOW );
		inMaler -> StrokePolygon ( sScaled, inPolyCount );
		//	delete:
		delete [] sScaled;
	};
};

void ObjectBitmap :: ObjektDraw (
		BView * inMaler, 
		unsigned int inTyp,
		unsigned int inOwner,
		unsigned int inZahl)
{
	//	Löschen des Hintergrunds:
	BRect Rand = inMaler -> Bounds ();
	inMaler -> SetDrawingMode ( B_OP_COPY );
	inMaler -> SetHighColor ( B_TRANSPARENT_32_BIT );
	inMaler -> FillRect ( Rand );
	
	//	Bestimmen der Farbe:
	rgb_color DieFarbe;
	switch ( inOwner )
	{
	case 0:	//	schwarz, mehrere
		DieFarbe = Color( 0x00, 0x00, 0x00, 0x00 );
		break;
	case 1:	//	weiß, neutral
		DieFarbe = Color( 0xff, 0xff, 0xff, 0x00 );
		break;
	case 2:	//	rot
		DieFarbe = Color( 0xff, 0x00, 0x00, 0x00 );
		break;
	case 3:	//	grün
		DieFarbe = Color( 0x00, 0xcc, 0x00, 0x00 );
		break;
	case 4:	//	blau
		DieFarbe = Color( 0x00, 0x00, 0xff, 0x00 );
		break;
	case 5:	//	gelb
		DieFarbe = Color( 0xff, 0xee, 0x00, 0x00 );
		break;
	default:	//	formel:
		DieFarbe = Color( inOwner * 233, inOwner * 113, inOwner * 61, 0x00 );
 	};
	inMaler -> SetLowColor ( DieFarbe );
 	rgb_color sForeColor;
	if ( DieFarbe . red * 0.3 + DieFarbe . green * 0.5 + DieFarbe . blue * 0.2 < 0x90 )
		sForeColor = Color ( 0xff, 0xff, 0xff, 0x00 );
	else
		sForeColor = Color ( 0x00, 0x00, 0x00, 0x00 );
	inMaler -> SetHighColor ( sForeColor );
	
	switch ( inTyp )
	{
	case Obj_Figur:
		StrokeScaledPoly ( inMaler, StopPoly, StopPolyCount );
		break;
	case Obj_Figur | Obj_BusyMask:
		StrokeScaledPoly ( inMaler, RunPoly, RunPolyCount );
		break;
	case Obj_Dorf:
	case Obj_Dorf | Obj_BusyMask:
		StrokeScaledPoly ( inMaler, VillagePoly, VillagePolyCount );
		break;
	case Obj_Mixed | Obj_BusyMask:
		StrokeScaledPoly ( inMaler, VillagePoly, VillagePolyCount );
		StrokeScaledPoly ( inMaler, RunPoly, RunPolyCount );
		break;
	case Obj_Mixed:
	default:
		StrokeScaledPoly ( inMaler, VillagePoly, VillagePolyCount );
		StrokeScaledPoly ( inMaler, StopPoly, StopPolyCount );
	};
	
	//	Malen der Zahl;
	if ( ( inZahl != 1 ) && ( ( inZahl != 2 ) || ( ( inTyp & Obj_TypeMask ) != Obj_Mixed ) ) )
	{
		char * DieZahl = IntToString ( inZahl );
		if ( DieZahl != NULL )
		{
			inMaler -> SetFontSize ( _Ebene_h_Objekt_Hoehe * 0.6 );
			inMaler -> SetHighColor ( DieFarbe );
			inMaler -> SetLowColor ( DieFarbe );
			inMaler -> MovePenTo ( _Ebene_h_Objekt_Breite * 0.5
				- 0.5 * inMaler -> StringWidth ( DieZahl ) - 1,
				_Ebene_h_Objekt_Hoehe * 0.7 - 1);
			inMaler -> DrawString ( DieZahl );
			inMaler -> MovePenTo ( _Ebene_h_Objekt_Breite * 0.5
				- 0.5 * inMaler -> StringWidth ( DieZahl ) + 1,
				_Ebene_h_Objekt_Hoehe * 0.7 + 1);
			inMaler -> DrawString ( DieZahl );
			inMaler -> MovePenTo ( _Ebene_h_Objekt_Breite * 0.5
				- 0.5 * inMaler -> StringWidth ( DieZahl ) - 1,
				_Ebene_h_Objekt_Hoehe * 0.7 + 1);
			inMaler -> DrawString ( DieZahl );
			inMaler -> MovePenTo ( _Ebene_h_Objekt_Breite * 0.5
				- 0.5 * inMaler -> StringWidth ( DieZahl ) + 1,
				_Ebene_h_Objekt_Hoehe * 0.7 - 1);
			inMaler -> DrawString ( DieZahl );
			inMaler -> SetHighColor ( sForeColor );
			inMaler -> SetLowColor ( DieFarbe );
			inMaler -> MovePenTo ( _Ebene_h_Objekt_Breite * 0.5
				- 0.5 * inMaler -> StringWidth ( DieZahl ),
				_Ebene_h_Objekt_Hoehe * 0.7 );
			inMaler -> DrawString ( DieZahl );
			delete DieZahl;
		};
	};
};



//
//	Ende.
//
// // // // // // // // // // // // // // // //